.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XMapEvent __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XMapEvent, XMappingEvent \- MapNotify and MappingNotify event structures
.SH STRUCTURES
The structure for
.B MapNotify
events contains:
.LP
.EX
typedef struct {
        int type;       /\&* MapNotify */
        unsigned long serial;   /\&* # of last request processed by server */
        Bool send_event;        /\&* true if this came from a SendEvent request */
        Display *display;       /\&* Display the event was read from */
        Window event;
        Window window;
        Bool override_redirect; /\&* boolean, is override set... */
} XMapEvent;
.EE
.LP
When you receive this event,
the structure members are set as follows.
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.B GraphicsExpose
event to a client application, it sends an
.B XGraphicsExposeEvent
structure with the type member set to
.BR GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.B True
if the event came from a
.B SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
The event member is set either to the window that was mapped or to its parent,
depending on whether
.B StructureNotify
or
.B SubstructureNotify
was selected.
The window member is set to the window that was mapped.
The override_redirect member is set to the override-redirect attribute
of the window.
Window manager clients normally should ignore this window
if the override-redirect attribute is
.BR True ,
because these events usually are generated from pop-ups,
which override structure control.
.LP
The structure for
.B MappingNotify
events is:
.LP
.EX
typedef struct {
        int type;       /\&* MappingNotify */
        unsigned long serial;   /\&* # of last request processed by server */
        Bool send_event;        /\&* true if this came from a SendEvent request */
        Display *display;       /\&* Display the event was read from */
        Window window;  /\&* unused */
        int request;    /\&* one of MappingModifier, MappingKeyboard,
                   MappingPointer */
        int first_keycode;      /\&* first keycode */
        int count;      /\&* defines range of change with first_keycode*/
} XMappingEvent;
.EE
.LP
When you receive this event,
the structure members are set as follows.
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.B GraphicsExpose
event to a client application, it sends an
.B XGraphicsExposeEvent
structure with the type member set to
.BR GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.B True
if the event came from a
.B SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
The request member is set to indicate the kind of mapping change that occurred
and can be
.BR MappingModifier ,
.BR MappingKeyboard ,
.BR MappingPointer .
If it is
.BR MappingModifier ,
the modifier mapping was changed.
If it is
.BR MappingKeyboard ,
the keyboard mapping was changed.
If it is
.BR MappingPointer ,
the pointer button mapping was changed.
The first_keycode and count members are set only
if the request member was set to
.BR MappingKeyboard .
The number in first_keycode represents the first number in the range
of the altered mapping,
and count represents the number of keycodes altered.
.SH "SEE ALSO"
.BR XAnyEvent (__libmansuffix__),
.BR XButtonEvent (__libmansuffix__),
.BR XCreateWindowEvent (__libmansuffix__),
.BR XCirculateEvent (__libmansuffix__),
.BR XCirculateRequestEvent (__libmansuffix__),
.BR XColormapEvent (__libmansuffix__),
.BR XConfigureEvent (__libmansuffix__),
.BR XConfigureRequestEvent (__libmansuffix__),
.BR XCrossingEvent (__libmansuffix__),
.BR XDestroyWindowEvent (__libmansuffix__),
.BR XErrorEvent (__libmansuffix__),
.BR XExposeEvent (__libmansuffix__),
.BR XFocusChangeEvent (__libmansuffix__),
.BR XGraphicsExposeEvent (__libmansuffix__),
.BR XGravityEvent (__libmansuffix__),
.BR XKeymapEvent (__libmansuffix__),
.BR XMapRequestEvent (__libmansuffix__),
.BR XPropertyEvent (__libmansuffix__),
.BR XReparentEvent (__libmansuffix__),
.BR XResizeRequestEvent (__libmansuffix__),
.BR XSelectionClearEvent (__libmansuffix__),
.BR XSelectionEvent (__libmansuffix__),
.BR XSelectionRequestEvent (__libmansuffix__),
.BR XUnmapEvent (__libmansuffix__),
.BR XVisibilityEvent (__libmansuffix__)
.br
\fI\*(xL\fP
