.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Tue Aug 29 11:06:25 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_SET\\_FPREG" "3libunwind" "29 August 2023" "Programming Library " "Programming Library "
.SH NAME
unw_set_fpreg
\-\- set contents of floating\-point register 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_set_fpreg(unw_cursor_t *cp,
unw_regnum_t
reg,
unw_fpreg_t
val);
.br
.PP
.SH DESCRIPTION

.PP
The unw_set_fpreg()
routine sets the value of register 
reg
in the stack frame identified by cursor cp
to the 
value passed in val\&.
.PP
The register numbering is target\-dependent and described in separate 
manual pages (e.g., libunwind\-ia64(3libunwind) for the IA\-64 target). 
Furthermore, the exact set of accessible registers may depend on the 
type of frame that cp
is referring to. For ordinary stack 
frames, it is normally possible to access only the preserved 
(``callee\-saved\&'') registers and frame\-related registers (such as the 
stack\-pointer). However, for signal frames (see 
unw_is_signal_frame(3libunwind)),
it is usually possible to access 
all registers. 
.PP
Note that unw_set_fpreg()
can only write the contents of 
floating\-point registers. See unw_set_reg(3libunwind)
for a way to 
write registers which fit in a single word. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_set_fpreg()
returns 0. 
Otherwise the negative value of one of the error codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_set_fpreg()
is thread safe as well as safe to use 
from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_EBADREG
 An attempt was made to write a register 
that is either invalid or not accessible in the current frame. 
.TP
UNW_EREADONLY
 An attempt was made to write to a 
read\-only register. 
.PP
In addition, unw_set_fpreg()
may return any error returned by 
the access_mem(),
access_reg(),
and 
access_fpreg()
callbacks (see 
unw_create_addr_space(3libunwind)).
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
libunwind\-ia64(3libunwind),
unw_get_fpreg(3libunwind),
unw_is_fpreg(3libunwind),
unw_is_signal_frame(3libunwind),
unw_set_reg(3libunwind)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
