]q (cpygments.token
_TokenType
qX   KeywordqX   Reservedqqqq}q(X   subtypesqcbuiltins
set
q	]q
qRqX   parentq
hhqqq}q(hh	]q(hhX   Wordqqqq}q(hh	]qqRqh
hubhhhqqq}q(hh	]qq Rq!h
hubhhX   Constantq"q#q$q%}q&(hh	]q'q(Rq)h
hubhhhX	   Namespaceq*q+q,q-}q.(hh	]q/q0Rq1h
hubhhX   Typeq2q3q4q5}q6(hh	]q7q8Rq9h
hubhhX   PreProcq:q;q<q=}q>(hh	]q?q@RqAh
hubhhX   ControlqBqCqDqE}qF(hh	]qGqHRqIh
hubhhX   PseudoqJqKqLqM}qN(hh	]qOqPRqQh
hubhhX   DeclarationqRqSqTqU}qV(hh	]qWqXRqYh
hubeqZRq[h
h)q\q]}q^(hh	]q_(hX   Punctuationq`qaqbqc}qd(hh	]qehh`X	   Indicatorqfqgqhqi}qj(hh	]qkqlRqmh
hcubaqnRqoh
h]hfhiubhX   Otherqpqqqrqs}qt(hh	]quqvRqwh
h]ubhX   Errorqxqyqzq{}q|(hh	]q}q~Rqh
h]ubhhX   Commentqqqq}q(hh	]q(hhX	   Directiveqqqq}q(hh	]qqRqh
hubhhX	   Multilineqqqq}q(hh	]qqRqh
hubhhX   Docqqqq}q(hh	]qqRqh
hubhhX   Multiqqqq}q(hh	]qqRqh
hubhhX
   Singlelineqqqq}q(hh	]qqRqh
hubhhX   Preprocqqqq}q(hh	]qqRqh
hubhhX   Hashbangqqqq}q(hh	]qqRqh
hubhhX   Singleqqqq}q(hh	]qÅqRqh
hubhhX   PreprocFileqƆqǅqȁq}q(hh	]q˅qRqh
hubhhX
   SingleLineqΆqυqЁq}q(hh	]qӅqRqh
hubhhX   Specialqֆqׅq؁q}q(hh	]qۅqRqh
hubeqRqh
h]hhhhhhhhhhhhhhhhhhhhhhubhX   Literalqqqq}q(hh	]q(hhX   Charqqqq}q(hh	]qqRqh
hubhhX   Scalarqqqq}q(hh	]qhhhX   Plainqqqq}q(hh	]qqRqh
hubaqRqh
hhhubhhX   Stringqqr   r  }r  (hh	]r  (hhhX   Momentr  r  r  r  }r  (hh	]r	  r
  Rr  h
j  ubhhhhr  r
  r  }r  (hh	]r  r  Rr  h
j  ubhhhX	   Delimeterr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhhr  r  r  }r  (hh	]r  r   Rr!  h
j  ubhhhX   Interpolr"  r#  r$  r%  }r&  (hh	]r'  r(  Rr)  h
j  ubhhhX   Escaper*  r+  r,  r-  }r.  (hh	]r/  r0  Rr1  h
j  ubhhhhr2  r3  r4  }r5  (hh	]r6  r7  Rr8  h
j  ubhhhX   Heredocr9  r:  r;  r<  }r=  (hh	]r>  r?  Rr@  h
j  ubhhhX   BacktickrA  rB  rC  rD  }rE  (hh	]rF  rG  RrH  h
j  ubhhhX   BooleanrI  rJ  rK  rL  }rM  (hh	]rN  rO  RrP  h
j  ubhhhX	   CharacterrQ  rR  rS  rT  }rU  (hh	]rV  rW  RrX  h
j  ubhhhX   AtomrY  rZ  r[  r\  }r]  (hh	]r^  r_  Rr`  h
j  ubhhhX   Affixra  rb  rc  rd  }re  (hh	]rf  rg  Rrh  h
j  ubhhhX   Doubleri  rj  rk  rl  }rm  (hh	]rn  ro  Rrp  h
j  ubhhhX   Symbolrq  rr  rs  rt  }ru  (hh	]rv  rw  Rrx  h
j  ubhhhX   Interpry  rz  r{  r|  }r}  (hh	]r~  r  Rr  h
j  ubhhhX   Regexr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhX   Namer  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhX	   Delimiterr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhhpr  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr  h
hja  jd  jA  jD  hj  j  j  hj4  ji  jl  j*  j-  j9  j<  j"  j%  hpj  j  j  hj  jq  jt  jQ  jT  j  j  jy  j|  jI  jL  j  j  jY  j\  j  j  ubhhhpr  r  r  }r  (hh	]r  r  Rr  h
hubhhX   Numberr  r  r  r  }r  (hh	]r  (hhj  X   Integerr  r  r  r  }r  (hh	]r  h(hj  j  X   Longr  tr  r  r  }r  (hh	]r  r  Rr  h
j  ubar  Rr  h
j  j  j  ubhhj  X   Floatr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Binr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Decr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Radixr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Decimalr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Octr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Hexr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X	   Attributer  r  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr   h
hj  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  ubhhX   Dater  r  r  r  }r  (hh	]r  r  Rr  h
huber	  Rr
  h
h]hj  j  j  j  j  hhhpj  hhubhj  r  r  r
  }r  (hh	]r  (hj  X   Blubbr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  X   Builtinr  r  r  r  }r  (hh	]r  (hj  j  hJr  r  r   }r!  (hh	]r"  r#  Rr$  h
j  ubhj  j  h2r%  r&  r'  }r(  (hh	]r)  r*  Rr+  h
j  uber,  Rr-  h
j
  hJj   h2j'  ubhj  X   Entityr.  r/  r0  r1  }r2  (hh	]r3  hj  j.  X   DBSr4  r5  r6  r7  }r8  (hh	]r9  r:  Rr;  h
j1  ubar<  Rr=  h
j
  j4  j7  ubhj  h"r>  r?  r@  }rA  (hh	]rB  rC  RrD  h
j
  ubhj  X   ClassrE  rF  rG  rH  }rI  (hh	]rJ  (hj  jE  X   StartrK  rL  rM  rN  }rO  (hh	]rP  rQ  RrR  h
jH  ubhj  jE  j4  rS  rT  rU  }rV  (hh	]rW  rX  RrY  h
jH  uberZ  Rr[  h
j
  jK  jN  j4  jU  ubhj  X	   Decoratorr\  r]  r^  r_  }r`  (hh	]ra  rb  Rrc  h
j
  ubhj  X   Functionrd  re  rf  rg  }rh  (hh	]ri  hj  jd  X   Magicrj  rk  rl  rm  }rn  (hh	]ro  rp  Rrq  h
jg  ubarr  Rrs  h
j
  jj  jm  ubhj  X   Operatorrt  ru  rv  rw  }rx  (hh	]ry  rz  Rr{  h
j
  ubhj  X   Propertyr|  r}  r~  r  }r  (hh	]r  r  Rr  h
j
  ubhj  X   Classesr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  jq  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  h2r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  h*r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  j  r  r  r  }r  (hh	]r  hj  j  X   Variabler  r  r  r  }r  (hh	]r  r  Rr  h
j  ubar  Rr  h
j
  j  j  ubhj  X   Fieldr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  X	   Exceptionr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  j  r  r  r  }r  (hh	]r  (hj  j  X	   Anonymousr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Instancer  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Globalr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  jj  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  jE  r  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr  h
j
  jE  j  j  j  j  j  jj  j  j  j  ubhj  X   Tagr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  hpr  r  r  }r  (hh	]r  hj  hpX   Memberr  r  r  r  }r  (hh	]r  r   Rr  h
j  ubar  Rr  h
j
  j  j  ubhj  X   Labelr  r  r  r  }r  (hh	]r	  r
  Rr  h
j
  ubhj  hJr  r
  r  }r  (hh	]r  r  Rr  h
j
  uber  Rr  h
h]j  j  j  j  jE  jH  h"j@  j\  j_  j.  j1  j  j  jd  jg  j|  j  j  j  h*j  hpj  j  j  j  j  j  j  jq  j  hJj  jt  jw  j  j  h2j  j  j  ubhX   Genericr  r  r  r  }r  (hh	]r  (hj  X
   Subheadingr  r  r  r  }r  (hh	]r   r!  Rr"  h
j  ubhj  X   Promptr#  r$  r%  r&  }r'  (hh	]r(  r)  Rr*  h
j  ubhj  X   Outputr+  r,  r-  r.  }r/  (hh	]r0  r1  Rr2  h
j  ubhj  X   Strongr3  r4  r5  r6  }r7  (hh	]r8  r9  Rr:  h
j  ubhj  hxr;  r<  r=  }r>  (hh	]r?  r@  RrA  h
j  ubhj  X	   TracebackrB  rC  rD  rE  }rF  (hh	]rG  rH  RrI  h
j  ubhj  X   EmphrJ  rK  rL  rM  }rN  (hh	]rO  rP  RrQ  h
j  ubhj  X   DeletedrR  rS  rT  rU  }rV  (hh	]rW  rX  RrY  h
j  ubhj  X   InsertedrZ  r[  r\  r]  }r^  (hh	]r_  r`  Rra  h
j  ubhj  X   Headingrb  rc  rd  re  }rf  (hh	]rg  rh  Rri  h
j  uberj  Rrk  h
h]jR  jU  jJ  jM  hxj=  jb  je  jZ  j]  j+  j.  j#  j&  j3  j6  j  j  jB  jE  ubhjt  rl  rm  rn  }ro  (hh	]rp  (hjt  j4  rq  rr  rs  }rt  (hh	]ru  rv  Rrw  h
jn  ubhjt  hrx  ry  rz  }r{  (hh	]r|  r}  Rr~  h
jn  uber  Rr  h
h]hjz  j4  js  ubhj*  r  r  r  }r  (hh	]r  r  Rr  h
h]ubhX   Textr  r  r  r  }r  (hh	]r  (hj  jq  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  h`r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Ragr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X
   Whitespacer  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Beerr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Rootr  r  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr  h
h]j  j  h`j  jq  j  j  j  j  j  j  j  uber  Rr  j  j  j*  j  hxh{hphshhj  j
  hhh`hcjt  jn  hhj  j  X   Tokenr  h]hj  j  j  ubh"h%hRhUh*h-hJhMhhh2h5hBhEhhh:h=hhububX    r  r  hX   % Copyright 2005 Brian Alliet
r  r  j  X   
r  r  hX   \documentclassr  r  j  X   [11pt]r  r  j  X   {r  r  j  X   articler  r  j  X   }r  r  j  j  r  hX   \usepackager  r  j  j  r  j  X   palatinor  r  j  j  r  j  j  r  hX   \usepackager  r  j  j  r  j  X   fullpager  r  j  j  r  j  j  r  hX   \usepackager  r  j  j  r  j  X   parskipr  r  j  j  r  j  j  r  hX   \usepackager  r  j  j  r  j  X   lhsr  r  j  j  r  j  X   

r  r  hX   \beginr  r  j  j  r  j  X   documentr  r  j  j  r  j  X   

r  r  hX   \titler  r  j  j  r  j  X
   Sudoku Solverr  r  j  j  r  j  j  r  hX   \authorr  r  j  j  r   j  X   Brian Allietr  r  j  j  r  j  j  r  hX
   \maketitler  r  j  X   

r  r  hX   \ignorer	  r
  j  j  r  j  j  r  hX   \beginr
  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  hX   moduler  r  j  X    r  r  j  X   Sudokur  r  j  j  r  hcX   (r  r  j  X   
    r  r  h5X   Sudokur  r   hcX   ,r!  r"  j  X   
    r#  r$  jg  X
   makeSudokur%  r&  hcj!  r'  j  j  r(  jg  X   solver)  r*  hcj!  r+  j  j  r,  jg  X	   eliminater-  r.  hcj!  r/  j  j  r0  jg  X   analyzer1  r2  hcj!  r3  j  j  r4  jg  X	   backtrackr5  r6  hcj!  r7  j  X   
    r8  r9  jg  X   mainr:  r;  j  X   
    r<  r=  hcX   )r>  r?  j  j  r@  hX   whererA  rB  j  X   

rC  rD  hX   importrE  rF  j  j  rG  j  X   ArrayrH  rI  j  j  rJ  hX   importrK  rL  j  j  rM  j  X   MonadrN  rO  j  j  rP  hX   importrQ  rR  j  j  rS  j  X   ListrT  rU  j  j  rV  hcj  rW  jg  X   unionrX  rY  hcj!  rZ  jg  X   intersperser[  r\  hcj!  r]  jg  X	   transposer^  r_  hcj!  r`  hcj  ra  jn  X   \\rb  rc  hcj>  rd  hcj!  re  jg  X   nubrf  rg  hcj!  rh  jg  X   nubByri  rj  hcj>  rk  j  j  rl  hX   \endrm  rn  j  j  ro  j  X   coderp  rq  j  j  rr  j  j  rs  j  j  rt  j  X   

ru  rv  hX   \sectionrw  rx  j  j  ry  j  X   Introductionrz  r{  j  j  r|  j  X5   

This Haskell module implements a solver for Sudoku~r}  r~  hX	   \footnoter  r  j  j  r  j  X#   http://en.wikipedia.org/wiki/Sudokur  r  j  j  r  j  XQ    puzzles. It can solve
any Sudoku puzzle, even those that require backtracking.

r  r  hX   \sectionr  r  j  j  r  j  X
   Data Typesr  r  j  j  r  j  X   

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  hX   datar  r  j  j  r  h5X	   CellStater  r  j  j  r  j
  X   ar  r  j  j  r  jz  X   =r  r  j  j  r  h5X   Knownr  r  j  j  r  j
  j  r  j  j  r  jn  X   |r  r  j  j  r  h5X   Unknownr  r  j  j  r  hcX   [r  r  j
  j  r  hcX   ]r  r  j  j  r  jn  j  r  j  j  r  h5X
   Impossibler  r  j  j  r  hX   derivingr  r  j  j  r  h5X   Eqr  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  Xf   

Each cell in a Sudoku grid can be in one of three states: ``Known'' if it has a known correct value~r  r  hX	   \footnoter  r  j  j  r  j  Xw   Actually
this doesn't always means it is correct. While we are in the backtracking stage we make our guesses ``Known''.r  r  j  j  r  j  X   ,
``Unknown'' if there is still more than one possible correct value, or ``Impossible'' if there is no value that can
possibly fit the cell. Sudoku grids with ``Impossible'' cells are quickly discarded by the r  r  j  j  r  hX   \ttr  r  j  X    solver  r  j  j  r  j  X    function.

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  hX   typer  r  j  j  r  h5X   Coordsr  r  j  j  r  jz  j  r  j  j  r  hcj  r  h5X   Intr  r  hcj!  r  h5X   Intr  r  hcj>  r  j  j  r  hX   typer  r  j  j  r  h5X   Gridr  r  j  j  r  j
  j  r  j  j  r  jz  j  r  j  j  r  h5X   Arrayr  r  j  j  r  h5X   Coordsr  r  j  j  r  hcj  r  h5X	   CellStater   r  j  j  r  j
  j  r  hcj>  r  j  j  r  hX   newtyper  r  j  j  r  h5X   Sudokur	  r
  j  j  r  j
  j  r  j  j  r
  jz  j  r  j  j  r  h5X   Sudokur  r  j  j  r  hcj  r  j  j  r  j
  X   unSudokur  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Gridr  r  j  j  r  j
  j  r  j  j  r  hcj  r   j  j  r!  hX   derivingr"  r#  j  j  r$  h5X   Eqr%  r&  j  j  r'  hX   \endr(  r)  j  j  r*  j  X   coder+  r,  j  j  r-  j  X   

We represent a Sudoku grid as an Array indexed by integer coordinates. We additionally define a newtype wrapper for the
grid. The smart constructor, r.  r/  j  j  r0  hX   \ttr1  r2  j  X    makeSudokur3  r4  j  j  r5  j  Xv    verifies some invariants before creating the Sudoku value. All the public
API functions operate on the Sudoku type.

r6  r7  hX   \beginr8  r9  j  j  r:  j  X   coder;  r<  j  j  r=  j  j  r>  j  j  r?  hX   instancer@  rA  j  j  rB  h5X   ShowrC  rD  j  j  rE  j
  j  rF  j  j  rG  jz  X   =>rH  rI  j  j  rJ  h5X   ShowrK  rL  j  j  rM  hcj  rN  h5X   SudokurO  rP  j  j  rQ  j
  j  rR  hcj>  rS  j  j  rT  hX   whererU  rV  j  j  rW  j
  X	   showsPrecrX  rY  j  j  rZ  j
  X   pr[  r\  j  j  r]  jz  j  r^  j  j  r_  j
  X	   showParenr`  ra  j  j  rb  hcj  rc  j
  j[  rd  jn  X   >re  rf  j  X   0rg  rh  hcj>  ri  j  j  rj  jn  X   .rk  rl  j  j  rm  j
  X	   showsGridrn  ro  j  j  rp  jn  jk  rq  j  j  rr  j
  X   unSudokurs  rt  j  j  ru  hX   instancerv  rw  j  j  rx  h5X   Showry  rz  j  j  r{  j
  j  r|  j  j  r}  jz  X   =>r~  r  j  j  r  h5X   Showr  r  j  j  r  hcj  r  h5X	   CellStater  r  j  j  r  j
  j  r  hcj>  r  j  j  r  hX   wherer  r  j  j  r  j
  X	   showsPrecr  r  j  j  r  hX   _r  r  j  j  r  jz  j  r  j  j  r  j
  X	   showsCellr  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  X   

We define r  r  j  j  r  hX   \ttr  r  j  X    Showr  r  j  j  r  j  X!    instances for the above types.

r  r  hX   \sectionr  r  j  j  r  j  X   Internal Functionsr  r  j  j  r  j  X   

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X   sizer  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Gridr  r  j  j  r  j
  j  r  j  j  r  jz  X   ->r  r  j  j  r  h5X   Intr  r  j  j  r  jg  X   sizer  r  j  j  r  jz  j  r  j  j  r  hcj  r  jn  X   +r  r  j  X   1r  r  hcj>  r  jn  jk  r  j
  X   fstr  r  jn  jk  r  j
  X   sndr  r  jn  jk  r  j
  X   boundsr  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  X   

r  r  j  j  r  hX   \ttr  r  j  X    sizer  r  j  j  r  j  X    returns the size (the width, height, and number of subboxes) for a Sudoku grid. We ensure Grid's are always
square and indexed starting at r  r  j  X   $r  r  jn  j  r  j  jg  r  j  j!  r  j  jg  r  jn  j>  r  j  j  r  j  XH    so simply incrementing either of the array's upper bounds is correct.

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r   jg  X   getRowr  r  hcj!  r  j
  X   getColr  r  hcj!  r  j
  X   getBoxr  r  j  j  r	  jz  X   ::r
  r  j  j  r  h5X   Gridr
  r  j  j  r  j
  j  r  j  j  r  jz  X   ->r  r  j  j  r  h5X   Intr  r  j  j  r  jz  X   ->r  r  j  j  r  hcj  r  hcj  r  h5X   Coordsr  r  hcj!  r  h5X	   CellStater   r!  j  j  r"  j
  j  r#  hcj>  r$  hcj  r%  j  j  r&  jg  X   getRowr'  r(  j  j  r)  j
  X   gridr*  r+  j  j  r,  j
  X   rr-  r.  j  j  r/  jz  j  r0  j  j  r1  hcj  r2  hX   letr3  r4  j  j  r5  j
  X   lr6  r7  j  j  r8  jz  j  r9  j  j  r:  hcj  r;  j
  j-  r<  hcj!  r=  j
  X   cr>  r?  hcj>  r@  j  j  rA  hX   inrB  rC  j  j  rD  hcj  rE  j
  j6  rF  hcj!  rG  j
  X   gridrH  rI  jn  X   !rJ  rK  j
  j6  rL  hcj>  rM  jn  j  rN  j
  j>  rO  j  j  rP  jz  X   <-rQ  rR  j  j  rS  hcj  rT  j  jg  rU  jn  X   ..rV  rW  j
  X   sizerX  rY  j  j  rZ  j
  X   gridr[  r\  j  j  r]  jn  X   -r^  r_  j  j  r`  j  j  ra  hcj  rb  hcj  rc  j  j  rd  jg  X   getColre  rf  j  j  rg  j
  X   gridrh  ri  j  j  rj  j
  j>  rk  j  j  rl  jz  j  rm  j  j  rn  hcj  ro  hX   letrp  rq  j  j  rr  j
  j6  rs  j  j  rt  jz  j  ru  j  j  rv  hcj  rw  j
  j-  rx  hcj!  ry  j
  j>  rz  hcj>  r{  j  j  r|  hX   inr}  r~  j  j  r  hcj  r  j
  j6  r  hcj!  r  j
  X   gridr  r  jn  jJ  r  j
  j6  r  hcj>  r  jn  j  r  j
  j-  r  j  j  r  jz  X   <-r  r  j  j  r  hcj  r  j  jg  r  jn  X   ..r  r  j
  X   sizer  r  j  j  r  j
  X   gridr  r  j  j  r  jn  j^  r  j  j  r  j  j  r  hcj  r  hcj  r  j  j  r  jg  X   getBoxr  r  j  j  r  j
  X   gridr  r  j  j  r  j
  X   br  r  j  j  r  jz  j  r  j  j  r  hcj  r  hX   letr  r  j  j  r  j
  j6  r  j  j  r  jz  j  r  j  j  r  hcj  r  j
  j-  r  hcj!  r  j
  j>  r  hcj>  r  j  j  r  hX   inr  r  j  j  r  hcj  r  j
  j6  r  hcj!  r  j
  X   gridr  r  jn  jJ  r  j
  j6  r  hcj>  r  jn  j  r  j
  j-  r  j  j  r  jz  X   <-r  r  j  j  r  hcj  r  j
  X   boxRr  r  jn  X   ..r  r  j
  X   boxRr  r  jn  j  r  j
  X   boxNr  r  jn  j^  r  j  j  r  hcj  r  hcj!  r  j
  j>  r  j  j  r  jz  X   <-r  r  j  j  r  hcj  r  j
  X   boxCr  r  jn  X   ..r  r  j
  X   boxCr  r  jn  j  r  j
  X   boxNr  r  jn  j^  r  j  j  r  hcj  r  hcj  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  j
  X   boxNr  r  j  j  r  jz  j  r  j  j  r  j
  X   intSqrtr  r  j  j  r  hcj  r  j
  X   sizer  r  j  j  r  j
  X   gridr  r  hcj>  r  hcX   ;r  r  j  j  r   j
  X   boxRr  r  j  j  r  jz  j  r  j  j  r  j
  j  r  j  j  r  hcX   `r  r	  j
  X   quotr
  r  hcj  r  j  j  r
  j
  X   boxNr  r  j  j  r  jn  X   *r  r  j  j  r  j
  X   boxNr  r  hcj  r  j  j  r  j
  X   boxCr  r  j  j  r  jz  j  r  j  j  r  j
  j  r  j  j  r  hcj  r  j
  X   remr   r!  hcj  r"  j  X     r#  r$  j
  X   boxNr%  r&  j  j  r'  jn  j  r(  j  j  r)  j
  X   boxNr*  r+  j  X   

r,  r-  jg  X   getBoxOfr.  r/  j  j  r0  jz  X   ::r1  r2  j  j  r3  h5X   Gridr4  r5  j  j  r6  j
  j  r7  j  j  r8  jz  X   ->r9  r:  j  j  r;  h5X   Coordsr<  r=  j  j  r>  jz  X   ->r?  r@  j  j  rA  hcj  rB  hcj  rC  h5X   CoordsrD  rE  hcj!  rF  h5X	   CellStaterG  rH  j  j  rI  j
  j  rJ  hcj>  rK  hcj  rL  j  j  rM  jg  X   getBoxOfrN  rO  j  j  rP  j
  X   gridrQ  rR  j  j  rS  hcj  rT  j
  j-  rU  hcj!  rV  j
  j>  rW  hcj>  rX  j  j  rY  jz  j  rZ  j  j  r[  j
  X   gridr\  r]  j  j  r^  hcj  r_  j
  X   getBoxr`  ra  hcj  rb  j  j  rc  hcj  rd  hcj  re  j
  j-  rf  j  j  rg  hcj  rh  j
  X   quotri  rj  hcj  rk  j  j  rl  j
  X   boxNrm  rn  j  j  ro  jn  j  rp  j  j  rq  j
  X   boxNrr  rs  hcj>  rt  j  j  ru  jn  j  rv  j  j  rw  hcj  rx  j
  j>  ry  j  j  rz  hcj  r{  j
  X   quotr|  r}  hcj  r~  j  j  r  j
  X   boxNr  r  hcj>  r  hcj>  r  j  X   
    r  r  hX   wherer  r  j  j  r  j
  X   boxNr  r  j  j  r  jz  j  r  j  j  r  j
  X   intSqrtr  r  j  j  r  hcj  r  j
  X   sizer  r  j  j  r  j
  X   gridr  r  hcj>  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  X   

r  r  j  j  r  hX   \ttr  r  j  X    getRowr  r  j  j  r  j  X   , r  r  j  j  r  hX   \ttr  r  j  X    getColr  r  j  j  r  j  X   , and r  r  j  j  r  hX   \ttr  r  j  X    getBoxr  r  j  j  r  j  XM    return the coordinates and values of the cell in row, column, or box
number r  r  j  j  r  hX   \ttr  r  j  X    nr  r  j  j  r  j  X   , r  r  j  j  r  hX   \ttr  r  j  X    rr  r  j  j  r  j  X   , or r  r  j  j  r  hX   \ttr  r  j  X    br  r  j  j  r  j  X   .

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X   getNeighborsr  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Eqr  r  j  j  r  j
  j  r  j  j  r  jz  X   =>r  r  j  j  r  h5X   Gridr  r  j  j  r  j
  j  r  j  j  r  jz  X   ->r  r  j  j  r  h5X   Coordsr  r  j  j  r  jz  X   ->r  r  j  j  r  hcj  r  hcj  r  h5X   Coordsr  r  hcj!  r  h5X	   CellStater  r  j  j  r  j
  j  r  hcj>  r  hcj  r  j  j  r   jg  X   getNeighborsr  r  j  j  r  j
  X   gridr  r  j  j  r  j
  j6  r  jn  X   @r  r	  hcj  r
  j
  j-  r  hcj!  r  j
  j>  r
  hcj>  r  j  j  r  jz  j  r  j  j  r  j
  X   filterr  r  j  j  r  hcj  r  hcj  r  jn  X   /=r  r  j
  j6  r  hcj>  r  jn  jk  r  j
  X   fstr  r  hcj>  r  j  X    
                          r  r   jn  j  r!  j  j  r"  j
  X   foldrr#  r$  j  j  r%  hcj  r&  j
  X   unionr'  r(  jn  jk  r)  hcj  r*  jn  j  r+  j
  X   gridr,  r-  hcj>  r.  hcj>  r/  j  j  r0  h5X   []r1  r2  j  X    
                          r3  r4  hcj  r5  hcj  r6  hcj  r7  j
  X   getRowr8  r9  hcj  r:  j
  j-  r;  hcj>  r<  hcj!  r=  hcj  r>  hcj  r?  j
  X   getColr@  rA  hcj  rB  j
  j>  rC  hcj>  rD  hcj!  rE  hcj  rF  hcj  rG  j
  X   getBoxOfrH  rI  hcj  rJ  j
  j6  rK  hcj>  rL  hcj  rM  j  j  rN  hX   \endrO  rP  j  j  rQ  j  X   coderR  rS  j  j  rT  j  X   

rU  rV  j  j  rW  hX   \ttrX  rY  j  X
    getNeighborsrZ  r[  j  j  r\  j  XH    returns the coordinates and values of all the neighbors of this cell.

r]  r^  hX   \beginr_  r`  j  j  ra  j  X   coderb  rc  j  j  rd  j  j  re  j  j  rf  jg  X
   impossiblerg  rh  j  j  ri  jz  X   ::rj  rk  j  j  rl  h5X   Eqrm  rn  j  j  ro  j
  j  rp  j  j  rq  jz  X   =>rr  rs  j  j  rt  h5X   Gridru  rv  j  j  rw  j
  j  rx  j  j  ry  jz  X   ->rz  r{  j  j  r|  h5X   Coordsr}  r~  j  j  r  jz  X   ->r  r  j  j  r  hcj  r  j
  j  r  hcj  r  j  j  r  jg  X
   impossibler  r  j  j  r  j
  X   gridr  r  j  j  r  j
  j6  r  j  j  r  jz  j  r  j  j  r  j
  X   mapr  r  j  j  r  j
  X   sndr  r  j  j  r  jn  j  r  j  j  r  j
  X
   justKnownsr  r  j  j  r  jn  j  r  j  j  r  j
  X   gridr  r  j  j  r  hcj  r  j
  X   getNeighborsr  r  hcj  r  j  j  r  j
  j6  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  X   

r  r  j  j  r  hX   \ttr  r  j  X    impossibler  r  j  j  r  j  X}    returns a list of impossible values for a given cell. The impossible values consist of the values any
``Known'' neighbors.

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X   justUnknownsr  r  j  j  r  jz  X   ::r  r  j  j  r  hcj  r  hcj  r  h5X   Coordsr  r  hcj!  r  h5X	   CellStater  r  j  j  r  j
  j  r  hcj>  r  hcj  r  j  j  r  jz  X   ->r  r  j  j  r  hcj  r  hcj  r  h5X   Coordsr  r  hcj!  r  hcj  r  j
  j  r  hcj  r  hcj>  r  hcj  r  j  j  r  jg  X   justUnknownsr  r  j  j  r  jz  j  r  j  j  r  j
  X   foldrr  r  j  j  r  hcj  r  jg  X   \r  r  j
  j>  r  j  j  r  jz  X   ->r  r  j  j  r  hX   caser  r  j  j  r  j
  j>  r  j  j  r  hX   ofr  r  j  j  r  hcj  r  j
  j[  r  hcj!  r  h5X   Unknownr  r  j  j  r  j
  X   xsr  r  hcj>  r 	  j  j  r	  jz  X   ->r	  r	  j  j  r	  hcj  r	  hcj  r	  j
  j[  r	  hcj!  r	  j
  X   xsr		  r
	  hcj>  r	  h5X   :r	  r
	  hcj>  r	  hcj  r	  j  j  r	  hj  r	  j  j  r	  jz  X   ->r	  r	  j  j  r	  j
  X   idr	  r	  e(hcj>  r	  j  j  r	  h5X   []r	  r	  j  X   

r	  r	  jg  X
   justKnownsr	  r	  j  j  r 	  jz  X   ::r!	  r"	  j  j  r#	  hcj  r$	  hcj  r%	  h5X   Coordsr&	  r'	  hcj!  r(	  h5X	   CellStater)	  r*	  j  j  r+	  j
  j  r,	  hcj>  r-	  hcj  r.	  j  j  r/	  jz  X   ->r0	  r1	  j  j  r2	  hcj  r3	  hcj  r4	  h5X   Coordsr5	  r6	  hcj!  r7	  j
  j  r8	  hcj>  r9	  hcj  r:	  j  j  r;	  jg  X
   justKnownsr<	  r=	  j  j  r>	  jz  j  r?	  j  j  r@	  j
  X   foldrrA	  rB	  j  j  rC	  hcj  rD	  jg  j  rE	  j
  j>  rF	  j  j  rG	  jz  X   ->rH	  rI	  j  j  rJ	  hX   caserK	  rL	  j  j  rM	  j
  j>  rN	  j  j  rO	  hX   ofrP	  rQ	  j  j  rR	  hcj  rS	  j
  j[  rT	  hcj!  rU	  h5X   KnownrV	  rW	  j  j  rX	  j
  X   xrY	  rZ	  hcj>  r[	  j  j  r\	  jz  X   ->r]	  r^	  j  j  r_	  hcj  r`	  hcj  ra	  j
  j[  rb	  hcj!  rc	  j
  jY	  rd	  hcj>  re	  h5j	  rf	  hcj>  rg	  hcj  rh	  j  j  ri	  hj  rj	  j  j  rk	  jz  X   ->rl	  rm	  j  j  rn	  j
  X   idro	  rp	  hcj>  rq	  j  j  rr	  h5X   []rs	  rt	  j  j  ru	  hX   \endrv	  rw	  j  j  rx	  j  X   codery	  rz	  j  j  r{	  j  X   

r|	  r}	  j  j  r~	  hX   \ttr	  r	  j  X
    justUnknownsr	  r	  j  j  r	  j  X    and r	  r	  j  j  r	  hX   \ttr	  r	  j  X    justKnownsr	  r	  j  j  r	  j  Xd    return only the Known or Unknown values (with the constructor stripped off)
from a list of cells.

r	  r	  hX   \beginr	  r	  j  j  r	  j  X   coder	  r	  j  j  r	  j  j  r	  j  j  r	  jg  X
   updateGridr	  r	  j  j  r	  jz  X   ::r	  r	  j  j  r	  h5X   Gridr	  r	  j  j  r	  j
  j  r	  j  j  r	  jz  X   ->r	  r	  j  j  r	  hcj  r	  hcj  r	  h5X   Coordsr	  r	  hcj!  r	  h5X	   CellStater	  r	  j  j  r	  j
  j  r	  hcj>  r	  hcj  r	  j  j  r	  jz  X   ->r	  r	  j  j  r	  h5X   Mayber	  r	  j  j  r	  hcj  r	  h5X   Gridr	  r	  j  j  r	  j
  j  r	  hcj>  r	  j  j  r	  jg  X
   updateGridr	  r	  j  j  r	  hj  r	  j  j  r	  h5X   []r	  r	  j  j  r	  jz  j  r	  j  j  r	  h5X   Nothingr	  r	  j  j  r	  jg  X
   updateGridr	  r	  j  j  r	  j
  X   gridr	  r	  j  j  r	  j
  X   xsr	  r	  j  j  r	  jz  j  r	  j  j  r	  h5X   Justr	  r	  j  j  r	  jn  j  r	  j  j  r	  j
  X   gridr	  r	  j  j  r	  jn  X   //r	  r	  j  j  r	  j
  X   nubByr	  r	  j  j  r	  hcj  r	  jg  j  r	  hcj  r	  j
  jY	  r	  hcj!  r	  hj  r	  hcj>  r	  j  j  r	  hcj  r	  j
  X   yr	  r	  hcj!  r	  hj  r	  hcj>  r	  j  j  r	  jz  X   ->r	  r	  j  j  r	  j
  jY	  r	  jn  X   ==r	  r	  j
  j	  r	  hcj>  r	  j  j  r	  j
  X   xsr	  r	  j  j  r	  hX   \endr	  r	  j  j  r 
  j  X   coder
  r
  j  j  r
  j  X   

r
  r
  j  j  r
  hX   \ttr
  r
  j  X    updateGridr	
  r

  j  j  r
  j  XV    applies a set of updates to a grid and returns the new grid only if it was updated.

r
  r
  hX   \sectionr
  r
  j  j  r
  j  X
   Public APIr
  r
  j  j  r
  j  X   

r
  r
  hX   \beginr
  r
  j  j  r
  j  X   coder
  r
  j  j  r
  j  j  r
  j  j  r
  jg  X
   makeSudokur
  r
  j  j  r 
  jz  X   ::r!
  r"
  j  j  r#
  hcj  r$
  h5X   Numr%
  r&
  j  j  r'
  j
  j  r(
  hcj!  r)
  j  j  r*
  h5X   Ordr+
  r,
  j  j  r-
  j
  j  r.
  hcj!  r/
  j  j  r0
  h5X   Enumr1
  r2
  j  j  r3
  j
  j  r4
  hcj>  r5
  j  j  r6
  jz  X   =>r7
  r8
  j  j  r9
  hcj  r:
  hcj  r;
  j
  j  r<
  hcj  r=
  hcj  r>
  j  j  r?
  jz  X   ->r@
  rA
  j  j  rB
  h5X   SudokurC
  rD
  j  j  rE
  j
  j  rF
  j  j  rG
  jg  X
   makeSudokurH
  rI
  j  j  rJ
  j
  X   xsrK
  rL
  j  X   
    rM
  rN
  jn  j  rO
  j  j  rP
  j
  X   notrQ
  rR
  j  j  rS
  hcj  rT
  j
  X   allrU
  rV
  j  j  rW
  hcj  rX
  hcj  rY
  jn  X   ==rZ
  r[
  j
  X   sizer\
  r]
  hcj>  r^
  jn  jk  r_
  j
  X   lengthr`
  ra
  hcj>  rb
  j  j  rc
  j
  X   xsrd
  re
  hcj>  rf
  j  j  rg
  jz  j  rh
  j  j  ri
  j  X   errorrj
  rk
  j  j  rl
  j  X   "rm
  rn
  j  X   error not a squarero
  rp
  j  jm
  rq
  j  X   
    rr
  rs
  jn  j  rt
  j  j  ru
  hcj  rv
  j
  X   intSqrtrw
  rx
  j  j  ry
  j
  X   sizerz
  r{
  hcj>  r|
  jn  X   ^r}
  r~
  hcj  r
  j  X   2r
  r
  jz  X   ::r
  r
  h5X   Intr
  r
  hcj>  r
  j  j  r
  jn  X   /=r
  r
  j  j  r
  j
  X   sizer
  r
  j  j  r
  jz  j  r
  j  j  r
  j  X   errorr
  r
  j  j  r
  j  jm
  r
  j  X!   error dims aren't perfect squaresr
  r
  j  jm
  r
  j  X   
    r
  r
  jn  j  r
  j  j  r
  j
  X   anyr
  r
  j  j  r
  hcj  r
  jg  j  r
  j
  jY	  r
  j  j  r
  jz  X   ->r
  r
  j  j  r
  j
  jY	  r
  j  j  r
  jn  X   <r
  r
  j  j  r
  j  jg  r
  j  j  r
  jn  X   ||r
  r
  j  j  r
  j
  jY	  r
  j  j  r
  jn  je  r
  j  j  r
  j
  X   fromIntegralr
  r
  j  j  r
  j
  X   sizer
  r
  hcj>  r
  j  j  r
  hcj  r
  j
  X   concatr
  r
  j  j  r
  j
  X   xsr
  r
  hcj>  r
  j  j  r
  jz  j  r
  j  j  r
  j  X   errorr
  r
  j  j  r
  j  jm
  r
  j  X   value out of ranger
  r
  j  jm
  r
  j  X   
    r
  r
  jn  j  r
  j  j  r
  j
  X	   otherwiser
  r
  j  j  r
  jz  j  r
  j  j  r
  h5X   Sudokur
  r
  j  j  r
  hcj  r
  j
  X	   listArrayr
  r
  j  j  r
  hcj  r
  hcj  r
  j  jg  r
  hcj!  r
  j  jg  r
  hcj>  r
  hcj!  r
  hcj  r
  j
  X   sizer
  r
  jn  j^  r
  j  j  r
  hcj!  r
  j
  X   sizer
  r
  jn  j^  r
  j  j  r
  hcj>  r
  hcj>  r
  j  j  r
  j
  X   statesr
  r
  hcj>  r
  j  X   
    r
  r
  hX   wherer
  r
  j  X	   
        r
  r
  j
  X   sizer
  r
  j  j  r
  jz  j  r
  j  j  r
  j
  X   lengthr
  r
  j  j  r
  j
  X   xsr   r  j  X	   
        r  r  j
  X   statesr  r  j  j  r  jz  j  r  j  j  r  j
  X   mapr	  r
  j  j  r  j
  X   fr  r
  j  j  r  hcj  r  j
  X   concatr  r  j  j  r  j
  X   xsr  r  hcj>  r  j  X	   
        r  r  j
  j  r  j  j  r  j  jg  r  j  j  r  jz  j  r  j  j  r  h5X   Unknownr  r  j  j  r   hcj  r!  j  j  r"  jn  X   ..r#  r$  j
  X   fromIntegralr%  r&  j  j  r'  j
  X   sizer(  r)  hcj  r*  j  X	   
        r+  r,  j
  j  r-  j  j  r.  j
  jY	  r/  j  j  r0  jz  j  r1  j  j  r2  h5X   Knownr3  r4  j  j  r5  j
  jY	  r6  j  j  r7  hX   \endr8  r9  j  j  r:  j  X   coder;  r<  j  j  r=  j  X   

r>  r?  j  j  r@  hX   \ttrA  rB  j  X    makeSudokurC  rD  j  j  rE  j  X	    makes a rF  rG  j  j  rH  hX   \ttrI  rJ  j  X    SudokurK  rL  j  j  rM  j  X    value from a list of numbers. The given matrix must be square and have dimensions
that are a perfect square. The possible values for each cell range from 1 to the dimension of the square with ``0''
representing unknown values.rN  rO  hX	   \footnoterP  rQ  j  j  rR  j  X   The rest of the code doesn't depend on any of this weird ``0'' is unknown
representation. In fact, it doesn't depend on numeric values at all. ``0'' is just used here because it makes
representing grids in Haskell source code easier.rS  rT  j  j  rU  j  X   

rV  rW  hX   \beginrX  rY  j  j  rZ  j  X   coder[  r\  j  j  r]  j  j  r^  j  j  r_  jg  X	   eliminater`  ra  j  j  rb  jz  X   ::rc  rd  j  j  re  h5X   Eqrf  rg  j  j  rh  j
  j  ri  j  j  rj  jz  X   =>rk  rl  j  j  rm  h5X   Sudokurn  ro  j  j  rp  j
  j  rq  j  j  rr  jz  X   ->rs  rt  j  j  ru  h5X   Mayberv  rw  j  j  rx  hcj  ry  h5X   Sudokurz  r{  j  j  r|  j
  j  r}  hcj>  r~  j  j  r  jg  X	   eliminater  r  j  j  r  hcj  r  h5X   Sudokur  r  j  j  r  j
  X   gridr  r  hcj>  r  j  j  r  jz  j  r  j  j  r  j
  X   fmapr  r  j  j  r  h5X   Sudokur  r  j  j  r  jn  j  r  j  j  r  j
  X
   updateGridr  r  j  j  r  j
  X   gridr  r  j  j  r  j
  X   changesr  r  j  j  r  jn  X   >>=r  r  j  j  r  j
  X   sanitizer  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  j
  X   changesr  r  j  j  r  jz  j  r  j  j  r  j
  X	   concatMapr  r  j  j  r  j
  X
   findChanger  r  j  j  r  jn  j  r  j  j  r  j
  X   assocsr  r  j  j  r  j
  X   gridr  r  j  X	   
        r  r  j
  X
   findChanger  r  j  j  r  hcj  r  j
  j6  r  hcj!  r  h5X   Unknownr  r  j  j  r  j
  X   xsr  r  hcj>  r  j  X    
            r  r  jz  j  r  j  j  r  j
  X   mapr  r  j  j  r  hcj  r  hcj  r  hcj!  r  hcj>  r  j  j  r  j
  j6  r  hcj>  r  j  X    
            r  r  jn  j  r  j  j  r  hX   caser  r  j  j  r  j
  X   filterr  r  j  j  r  hcj  r  j
  X   notr  r  jn  jk  r  hcj  r  hcj  r  j
  X   elemr  r  hcj  r  j
  X
   impossibler  r  j  j  r  j
  X   gridr  r  j  j  r  j
  j6  r  hcj>  r  hcj>  r  j  j  r  j
  X   xsr  r  j  j  r  hX   ofr  r  j  X   
                r  r  h5X   []r  r  j  j  r  jz  X   ->r  r  j  j  r   j
  X   returnr  r  j  j  r  h5X
   Impossibler  r  j  X   
                r  r  hcj  r  j
  jY	  r	  hcj  r
  j  j  r  jz  X   ->r  r
  j  j  r  j
  X   returnr  r  j  j  r  jn  j  r  j  j  r  h5X   Knownr  r  j  j  r  j
  jY	  r  j  X   
                r  r  j
  X   xs'r  r  j  X   
                    r  r  jn  j  r  j  j  r  j
  X   xs'r   r!  j  j  r"  jn  X   /=r#  r$  j  j  r%  j
  X   xsr&  r'  j  j  r(  jz  X   ->r)  r*  j  j  r+  j
  X   returnr,  r-  j  j  r.  jn  j  r/  j  j  r0  h5X   Unknownr1  r2  j  j  r3  j
  X   xs'r4  r5  j  X   
                    r6  r7  jn  j  r8  j  j  r9  j
  X	   otherwiser:  r;  j  j  r<  jz  X   ->r=  r>  j  j  r?  j
  X   mzeror@  rA  j  X	   
        rB  rC  j
  X
   findChangerD  rE  j  j  rF  hj  rG  j  j  rH  jz  j  rI  j  j  rJ  j
  X   mzerorK  rL  j  X	   
        rM  rN  j
  X   sanitizerO  rP  j  j  rQ  j
  X   gridrR  rS  j  j  rT  jz  j  rU  j  j  rV  j
  X   returnrW  rX  j  j  rY  jn  j  rZ  j  j  r[  j
  X   gridr\  r]  j  j  r^  jn  X   //r_  r`  j  j  ra  hcj  rb  hcj  rc  j
  j6  rd  hcj!  re  h5X
   Impossiblerf  rg  hcj>  rh  j  j  ri  jn  j  rj  j  X    
            rk  rl  hcj  rm  j
  j6  rn  hcj!  ro  j
  jY	  rp  hcj>  rq  j  j  rr  jz  X   <-rs  rt  j  j  ru  j
  X
   justKnownsrv  rw  j  j  rx  j
  X   changesry  rz  hcj!  r{  j  j  r|  j
  jY	  r}  j  j  r~  hcj  r  j
  X   elemr  r  hcj  r  j  j  r  j
  X
   impossibler  r  j  j  r  j
  X   gridr  r  j  j  r  j
  j6  r  hcj  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  X   

The r  r  j  j  r  hX   \ttr  r  j  X
    eliminater  r  j  j  r  j  X   phase tries to remove possible choices for ``Unknowns'' based on ``Known'' values in the same row,
column, or box as the ``Unknown'' value. For each cell on the grid we find its ``neighbors'', that is, cells in the
same row, column, or box. Out of those neighbors we get a list of all the ``Known'' values. We can eliminate all of
these from our list of candidates for this cell. If we're lucky enough to eliminate all the candidates but one we have
a new ``Known'' value. If we're unlucky enough to have eliminates r  r  j  j  r  hX   \bfr  r  j  X    allr  r  j  j  r  j  X    the possible candidates we have a new
``Impossible'' value.

After iterating though every cell we make one more pass looking for conflicting changes. r  r  j  j  r  hX   \ttr  r  j  X	    sanitizer  r  j  j  r  j  XI    marks cells as
``Impossible'' if we have conflicting ``Known'' values.

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X   analyzer  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Eqr  r  j  j  r  j
  j  r  j  j  r  jz  X   =>r  r  j  j  r  h5X   Sudokur  r  j  j  r  j
  j  r  j  j  r  jz  X   ->r  r  j  j  r  h5X   Mayber  r  j  j  r  hcj  r  h5X   Sudokur  r  j  j  r  j
  j  r  hcj>  r  j  j  r  jg  X   analyzer  r  j  j  r  hcj  r  h5X   Sudokur  r  j  j  r  j
  X   gridr  r  hcj>  r  j  j  r  jz  j  r  j  j  r  j
  X   fmapr  r  j  j  r  h5X   Sudokur  r  j  j  r  jn  j  r  j  j  r  j
  X
   updateGridr  r  j  j  r  j
  X   gridr  r  j  j  r  jn  j  r  j  j  r  j
  X   nubr  r  j  j  r  hcj  r  j
  X   ur  r  j  j  r  jn  j  r  j  X
   
            r  r  j
  j  r  j  j  r  jz  X   <-r  r  j  j  r 
  j
  X   mapr
  r
  j  j  r
  hcj  r
  jn  j  r
  j
  X   gridr
  r
  hcj>  r
  j  j  r	
  hcj  r

  j
  X   getRowr
  r
  hcj!  r

  j
  X   getColr
  r
  hcj!  r
  j
  X   getBoxr
  r
  hcj  r
  hcj!  r
  j  X
   
            r
  r
  j
  X   nr
  r
  j  j  r
  jz  X   <-r
  r
  j  j  r
  hcj  r
  j  jg  r
  jn  X   ..r
  r 
  j
  X   sizer!
  r"
  j  j  r#
  j
  X   gridr$
  r%
  j  j  r&
  jn  j^  r'
  j  j  r(
  j  j  r)
  hcj  r*
  hcj!  r+
  j  X
   
            r,
  r-
  j
  j  r.
  j  j  r/
  jz  X   <-r0
  r1
  j  j  r2
  j
  X   uniquer3
  r4
  j  j  r5
  hcj  r6
  j
  j  r7
  j  j  r8
  j
  j
  r9
  hcj>  r:
  hcj  r;
  j  X   
    r<
  r=
  hX   wherer>
  r?
  j  X	   
        r@
  rA
  j
  X   uniquerB
  rC
  j  j  rD
  j
  X   xsrE
  rF
  j  j  rG
  jz  j  rH
  j  j  rI
  j
  X   foldrrJ
  rK
  j  j  rL
  j
  j  rM
  j  j  rN
  h5X   []rO
  rP
  j  j  rQ
  jn  j  rR
  j  j  rS
  j
  X   foldrrT
  rU
  j  j  rV
  hcj  rW
  j
  X   unionrX
  rY
  jn  jk  rZ
  j
  X   sndr[
  r\
  hcj>  r]
  j  j  r^
  h5X   []r_
  r`
  j  j  ra
  j
  X   unknownsrb
  rc
  j  j  rd
  jn  X   \\re
  rf
  j  j  rg
  j
  X   maprh
  ri
  j  j  rj
  j
  X   sndrk
  rl
  j  j  rm
  hcj  rn
  j
  X
   justKnownsro
  rp
  j  j  rq
  j
  X   xsrr
  rs
  hcj>  rt
  j  X
   
            ru
  rv
  hX   whererw
  rx
  j  X   
                ry
  rz
  j
  X   unknownsr{
  r|
  j  j  r}
  jz  j  r~
  j  j  r
  j
  X   justUnknownsr
  r
  j  j  r
  j
  X   xsr
  r
  j  X   
                r
  r
  j
  j  r
  j  j  r
  j
  j>  r
  j  j  r
  jz  j  r
  j  j  r
  hX   caser
  r
  j  j  r
  j
  X   filterr
  r
  j  j  r
  hcj  r
  hcj  r
  j
  j>  r
  hcj  r
  j
  X   elemr
  r
  hcj  r
  hcj>  r
  jn  jk  r
  j
  X   sndr
  r
  hcj>  r
  j  j  r
  j
  X   unknownsr
  r
  j  j  r
  hX   ofr
  r
  j  X   
                    r
  r
  hcj  r
  hcj  r
  j
  j[  r
  hcj!  r
  hj  r
  hcj>  r
  hcj  r
  j  j  r
  jz  X   ->r
  r
  j  j  r
  hcj  r
  hcj  r
  j
  j[  r
  hcj!  r
  h5X   Knownr
  r
  j  j  r
  j
  j>  r
  hcj>  r
  h5j	  r
  hcj>  r
  j  X   
                    r
  r
  hj  r
  j  j  r
  jz  X   ->r
  r
  j  j  r
  j
  X   idr
  r
  j  j  r
  hX   \endr
  r
  j  j  r
  j  X   coder
  r
  j  j  r
  j  X   

The r
  r
  j  j  r
  hX   \ttr
  r
  j  X    analyzer
  r
  j  j  r
  j  X    phase tries to turn ``Unknowns'' into ``Knowns'' when a certain ``Unknown'' is the only cell that
contains a value needed in a given row, column, or box. We apply each of the functions r
  r
  j  j  r
  hX   \ttr
  r
  j  X    getRowr
  r
  j  j  r
  j  X   , r
  r
  j  j  r
  hX   \ttr
  r
  j  X    getColr
  r
  j  j  r
  j  X   , and
r
  r
  j  j  r
  hX   \ttr
  r
  j  X    getBoxr
  r
  j  j  r
  j  X'    to all the indices on the grid, apply r
  r
  j  j  r
  hX   \ttr
  r
  j  X    uniquer
  r
  j  j  r
  j  X7    to each group, and update the array with the
results. r
  r
  j  j  r
  hX   \ttr
  r
  j  X    uniquer
  r
  j  j  r
  j  X    gets a list of all  the unknown cells in the group and finds all the unknown values in each of
those cells. Each of these values are iterated though looking for a value that is only contained in one cell. If such a
value is found the cell containing it must be that value.

r
  r
  hX   \beginr
  r   j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X	   backtrackr  r  j  j  r	  jz  X   ::r
  r  j  j  r  hcj  r
  h5X	   MonadPlusr  r  j  j  r  j
  X   mr  r  hcj!  r  j  j  r  h5X   Eqr  r  j  j  r  j
  j  r  hcj>  r  j  j  r  jz  X   =>r  r  j  j  r  h5X   Sudokur  r  j  j  r   j
  j  r!  j  j  r"  jz  X   ->r#  r$  j  j  r%  j
  j  r&  j  j  r'  hcj  r(  h5X   Sudokur)  r*  j  j  r+  j
  j  r,  hcj>  r-  j  j  r.  jg  X	   backtrackr/  r0  j  j  r1  hcj  r2  h5X   Sudokur3  r4  j  j  r5  j
  X   gridr6  r7  hcj>  r8  j  j  r9  jz  j  r:  j  j  r;  hX   caser<  r=  j  j  r>  hcj  r?  j
  X   justUnknownsr@  rA  j  j  rB  hcj  rC  j
  X   assocsrD  rE  j  j  rF  j
  X   gridrG  rH  hcj>  rI  hcj>  rJ  j  j  rK  hX   ofrL  rM  j  X   
    rN  rO  h5X   []rP  rQ  j  j  rR  jz  X   ->rS  rT  j  j  rU  j
  X   returnrV  rW  j  j  rX  jn  j  rY  j  j  rZ  h5X   Sudokur[  r\  j  j  r]  j
  X   gridr^  r_  j  X   
    r`  ra  hcj  rb  hcj  rc  j
  j[  rd  e(hcj!  re  j
  X   xsrf  rg  hcj>  rh  h5j	  ri  hj  rj  hcj>  rk  j  j  rl  jz  X   ->rm  rn  j  j  ro  j
  X   msumrp  rq  j  j  rr  jn  j  rs  j  j  rt  j
  X   mapru  rv  j  j  rw  hcj  rx  jg  j  ry  j
  jY	  rz  j  j  r{  jz  X   ->r|  r}  j  j  r~  j
  X   solver  r  j  j  r  jn  j  r  j  j  r  h5X   Sudokur  r  j  j  r  jn  j  r  j  j  r  j
  X   gridr  r  j  j  r  jn  X   //r  r  j  j  r  hcj  r  hcj  r  j
  j[  r  hcj!  r  h5X   Knownr  r  j  j  r  j
  jY	  r  hcj>  r  hcj  r  hcj>  r  j  j  r  j
  X   xsr  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  X  

Sometimes the above two phases still aren't enough to solve a puzzle. For these rare puzzles backtracking is required.
We attempt to solve the puzzle by replacing the first ``Unknown'' value with each of the candidate values and solving
the resulting puzzles. Hopefully at least one of our choices will result in a solvable puzzle.

We could actually solve any puzzle using backtracking alone, although this would be very inefficient. The above
functions simplify most puzzles enough that the backtracking phase has to do hardly any work.

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X   solver  r  j  j  r  jz  X   ::r  r  j  j  r  hcj  r  h5X	   MonadPlusr  r  j  j  r  j
  j  r  hcj!  r  j  j  r  h5X   Eqr  r  j  j  r  j
  j  r  hcj>  r  j  j  r  jz  X   =>r  r  j  j  r  h5X   Sudokur  r  j  j  r  j
  j  r  j  j  r  jz  X   ->r  r  j  j  r  j
  j  r  j  j  r  hcj  r  h5X   Sudokur  r  j  j  r  j
  j  r  hcj>  r  j  j  r  jg  X   solver  r  j  j  r  j
  X   sudokur  r  j  j  r  jz  j  r  j  X    
    r  r  hX   caser  r  j  j  r  j
  X	   eliminater  r  j  j  r  j
  X   sudokur  r  j  j  r  hX   ofr  r  j  X	   
        r  r  h5X   Justr  r  j  j  r  j
  X   newr  r  j  X    
            r  r  jn  j  r  j  j  r  j
  X   anyr  r  j  j  r  hcj  r  jn  X   ==r  r  h5X
   Impossibler  r  hcj>  r  j  j  r  hcj  r  j
  X   elemsr  r   j  j  r  hcj  r  j
  X   unSudokur  r  j  j  r  j
  X   newr  r  hcj>  r  hcj>  r	  jz  X   ->r
  r  j  j  r  j
  X   mzeror
  r  j  X
   
            r  r  jn  j  r  j  j  r  j
  X	   otherwiser  r  j  j  r  jz  X   ->r  r  j  j  r  j
  X   solver  r  j  j  r  j
  X   newr  r  j  X	   
        r  r  h5X   Nothingr   r!  j  j  r"  jz  X   ->r#  r$  j  j  r%  hX   caser&  r'  j  j  r(  j
  X   analyzer)  r*  j  j  r+  j
  X   sudokur,  r-  j  j  r.  hX   ofr/  r0  j  X
   
            r1  r2  h5X   Justr3  r4  j  j  r5  j
  X   newr6  r7  j  j  r8  jz  X   ->r9  r:  j  j  r;  j
  X   solver<  r=  j  j  r>  j
  X   newr?  r@  j  X
   
            rA  rB  h5X   NothingrC  rD  j  j  rE  jz  X   ->rF  rG  j  j  rH  j
  X	   backtrackrI  rJ  j  j  rK  j
  X   sudokurL  rM  j  j  rN  hX   \endrO  rP  j  j  rQ  j  X   coderR  rS  j  j  rT  j  X   

rU  rV  j  j  rW  hX   \ttrX  rY  j  X    solverZ  r[  j  j  r\  j  X7    glues all the above phases together. First we run the r]  r^  j  j  r_  hX   \ttr`  ra  j  X
    eliminaterb  rc  j  j  rd  j  XL    phase. If that found the puzzle  to
be unsolvable we abort immediately. If re  rf  j  j  rg  hX   \ttrh  ri  j  X
    eliminaterj  rk  j  j  rl  j  X#    changed the grid we go though the rm  rn  j  j  ro  hX   \ttrp  rq  j  X
    eliminaterr  rs  j  j  rt  j  X,    phase again
hoping to eliminate more. Once ru  rv  j  j  rw  hX   \ttrx  ry  j  X
    eliminaterz  r{  j  j  r|  j  X'    can do no more work we move on to the r}  r~  j  j  r  hX   \ttr  r  j  X    analyzer  r  j  j  r  j  XI    phase. If this
succeeds in doing some work we start over again with the r  r  j  j  r  hX   \ttr  r  j  X
    eliminater  r  j  j  r  j  X
    phase. Once r  r  j  j  r  hX   \ttr  r  j  X    analyzer  r  j  j  r  j  X    can do no more work
we have no choice but to resort to backtracking. (However in most cases backtracking won't actually do anything because
the puzzle is already solved.)

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X	   showsCellr  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Showr  r  j  j  r  j
  j  r  j  j  r  jz  X   =>r  r  j  j  r  h5X	   CellStater  r  j  j  r  j
  j  r  j  j  r  jz  X   ->r  r  j  j  r  h5X   ShowSr  r  j  j  r  jg  X	   showsCellr  r  j  j  r  hcj  r  h5X   Knownr  r  j  j  r  j
  jY	  r  hcj>  r  j  j  r  jz  j  r  j  j  r  j
  X   showsr  r  j  j  r  j
  jY	  r  j  j  r  jg  X	   showsCellr  r  j  j  r  hcj  r  h5X
   Impossibler  r  hcj>  r  j  j  r  jz  j  r  j  j  r  j
  X   showCharr  r  j  j  r  j  X   'X'r  r  j  j  r  jg  X	   showsCellr  r  j  j  r  hcj  r  h5X   Unknownr  r  j  j  r  j
  X   xsr  r  hcj>  r  j  j  r  jz  j  r  j  j  r  jg  j  r  j
  X   restr  r  j  j  r  jz  X   ->r  r  j  j  r  hcj  r  j  X   '('r  r  h5j	  r  hcj>  r  j  X    
                       r  r  jn  j  r  j  j  r  j
  X   foldrr  r  j  j  r  j
  X   idr  r  j  j  r  hcj  r  j  X   ')'r  r  h5j	  r  j
  X   restr   r  hcj>  r  j  X   
                       r  r  jn  j  r  j  j  r  j
  X   intersperser  r  j  j  r	  hcj  r
  j
  X   showCharr  r  j  j  r
  j  X   ' 'r  r  hcj>  r  j  X   
                       r  r  jn  j  r  j  j  r  j
  X   mapr  r  j  j  r  j
  X   showsr  r  j  j  r  j
  X   xsr  r  j  j  r  hX   \endr  r  j  j  r   j  X   coder!  r"  j  j  r#  j  X   

r$  r%  j  j  r&  hX   \ttr'  r(  j  X	    showCellr)  r*  j  j  r+  j  X    shows a cell.

r,  r-  hX   \beginr.  r/  j  j  r0  j  X   coder1  r2  j  j  r3  j  j  r4  j  j  r5  jg  X	   showsGridr6  r7  j  j  r8  jz  X   ::r9  r:  j  j  r;  h5X   Showr<  r=  j  j  r>  j
  j  r?  j  j  r@  jz  X   =>rA  rB  j  j  rC  h5X   GridrD  rE  j  j  rF  j
  j  rG  j  j  rH  jz  X   ->rI  rJ  j  j  rK  h5X   ShowSrL  rM  j  j  rN  jg  X	   showsGridrO  rP  j  j  rQ  j
  X   gridrR  rS  j  j  rT  jz  j  rU  j  j  rV  j
  X
   showsTablerW  rX  j  j  rY  hcj  rZ  hcj  r[  j
  X   gridr\  r]  jn  jJ  r^  hcj  r_  j
  j-  r`  hcj!  ra  j
  j>  rb  hcj>  rc  j  j  rd  jn  j  re  j  j  rf  j
  j>  rg  j  j  rh  jz  X   <-ri  rj  j  j  rk  hcj  rl  j  jg  rm  jn  X   ..rn  ro  j
  X   sizerp  rq  j  j  rr  j
  X   gridrs  rt  jn  j^  ru  j  j  rv  hcj  rw  hcj  rx  j  j  ry  jn  j  rz  j  j  r{  j
  j-  r|  j  j  r}  jz  X   <-r~  r  j  j  r  hcj  r  j  jg  r  jn  X   ..r  r  j
  X   sizer  r  j  j  r  j
  X   gridr  r  jn  j^  r  j  j  r  hcj  r  hcj  r  j  j  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  X   

r  r  j  j  r  hX   \ttr  r  j  X	    showGridr  r  j  j  r  j  X    show a grid.

r  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  hX&   -- FEATURE: This is pretty inefficientr  r  j  j  r  jg  X
   showsTabler  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Showr  r  j  j  r  j
  j  r  j  j  r  jz  X   =>r  r  j  j  r  hcj  r  hcj  r  j
  j  r  hcj  r  hcj  r  j  j  r  jz  X   ->r  r  j  j  r  h5X   ShowSr  r  j  j  r  jg  X
   showsTabler  r  j  j  r  j
  X   xsr  r  j  j  r  jz  j  r  j  j  r  hcj  r  j
  X   showCharr  r  j  j  r  j  X   'r  r  j-  j  r  j-  j
  r  j  j  r  j  j  r  jn  jk  r  hcj>  r  j  j  r  jn  j  r  j  j  r  j
  X
   showStringr  r  j  j  r  jn  j  r  j  j  r  j
  X   unlinesr  r  j  j  r  jn  j  r  j  j  r  j
  X   mapr  r  j  j  r  hcj  r  j
  X   concatr  r  j  j  r  jn  jk  r  j  j  r  j
  X   intersperser  r  j  j  r  j  jm
  r  j  j  r  j  jm
  r  hcj>  r  j  j  r  j
  X   xs''r  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  j
  X   xs'r  r  j  j  r   jz  j  r  j  j  r  hcj  r  j
  X   mapr  r  jn  jk  r  j
  X   mapr  r  hcj>  r	  j  j  r
  j
  X   showr  r  j  j  r
  j
  X   xsr  r  j  X	   
        r  r  j
  X	   colWidthsr  r  j  j  r  jz  j  r  j  j  r  j
  X   mapr  r  j  j  r  hcj  r  j
  X   maxr  r  j  j  r  j  j
  r  j  j  r  jn  jk  r   j  j  r!  j
  X   maximumr"  r#  j  j  r$  jn  jk  r%  j  j  r&  j
  X   mapr'  r(  j  j  r)  j
  X   lengthr*  r+  hcj>  r,  j  j  r-  hcj  r.  j
  X	   transposer/  r0  j  j  r1  j
  X   xs'r2  r3  hcj>  r4  j  X	   
        r5  r6  j
  X   xs''r7  r8  j  j  r9  jz  j  r:  j  j  r;  j
  X   mapr<  r=  j  j  r>  hcj  r?  j
  X   zipWithr@  rA  j  j  rB  hcj  rC  jg  j  rD  j
  j
  rE  j  j  rF  j
  X   srG  rH  j  j  rI  jz  X   ->rJ  rK  j  j  rL  j
  jG  rM  j  j  rN  jn  X   ++rO  rP  j  j  rQ  hcj  rR  j
  X	   replicaterS  rT  j  j  rU  hcj  rV  j
  j
  rW  j  j  rX  jn  j^  rY  j  j  rZ  j
  X   lengthr[  r\  j  j  r]  j
  jG  r^  hcj>  r_  j  j  r`  j  X   ' 'ra  rb  hcj>  rc  hcj>  rd  j  j  re  j
  X	   colWidthsrf  rg  hcj>  rh  j  j  ri  j
  X   xs'rj  rk  j  j  rl  hX   \endrm  rn  j  j  ro  j  X   coderp  rq  j  j  rr  j  X   

rs  rt  j  j  ru  hX   \ttrv  rw  j  X    showsTablerx  ry  j  j  rz  j  XP    shows a table (or matrix). Every column has the same width so things line up.

r{  r|  hX   \beginr}  r~  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X   intSqrtr  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Integralr  r  j  j  r  j
  j  r  j  j  r  jz  X   =>r  r  j  j  r  j
  j  r  j  j  r  jz  X   ->r  r  j  j  r  j
  j  r  j  j  r  jg  X   intSqrtr  r  j  j  r  j
  j
  r  j  X   
    r  r  jn  j  r  j  j  r  j
  j
  r  j  j  r  jn  j
  r  j  j  r  j  jg  r  j  j  r  jz  j  r  j  j  r  j  X   errorr  r  j  j  r  j  jm
  r  j  X   intSqrt: negative nr  r  j  jm
  r  j  X   
    r  r  jn  j  r  j  j  r  j
  X	   otherwiser  r  j  j  r  jz  j  r  j  j  r  j
  j  r  j  j  r  j
  j
  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  j
  j  r  j  j  r  j
  jY	  r  j  j  r  jz  j  r  j  j  r  hX   ifr  r  j  j  r  j
  j	  r  j  j  r  jn  j
  r  j  j  r  j
  jY	  r  j  j  r  hX   thenr  r  j  j  r  j
  j  r  j  j  r  j
  j	  r  j  j  r  hX   elser  r  j  j  r  j
  jY	  r  j  X
   
            r  r  hX   wherer  r  j  j  r  j
  j	  r  j  j  r  jz  j  r  j  j  r  hcj  r  j
  jY	  r  j  j  r  jn  j  r  j  j  r  hcj  r  j
  j
  r  j  j  r  hcj  r  j
  X   quotr  r  hcj  r  j  j  r  j
  jY	  r  hcj>  r  hcj>  r  j  j  r  hcj  r  j
  X   quotr  r  hcj  r  j  j  r  j  j
  r  j  j  r  hX   \endr  r  j  j  r   j  X   coder  r  j  j  r  j  X   

r  r  j  j  r  hX   \ttr  r  j  X    intSqrtr	  r
  j  j  r  j  X;    is Newton`s Iteration for finding integral square roots.

r  r
  hX   \ignorer  r  j  j  r  j  j  r  hX   \beginr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  jg  X   testr  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Sudokur   r!  j  j  r"  h5X   Intr#  r$  j  j  r%  jg  X   testr&  r'  j  j  r(  jz  j  r)  j  j  r*  j
  X
   makeSudokur+  r,  j  j  r-  hcj  r.  j  X   
    r/  r0  hcj  r1  j  jg  r2  hcj!  r3  j  X   6r4  r5  hcj!  r6  j  jg  r7  hcj!  r8  j  j  r9  hcj!  r:  j  jg  r;  hcj!  r<  j  X   4r=  r>  hcj!  r?  j  jg  r@  hcj!  rA  j  X   5rB  rC  hcj!  rD  j  jg  rE  hcj  rF  hcj!  rG  j  X   
    rH  rI  hcj  rJ  j  jg  rK  hcj!  rL  j  jg  rM  hcj!  rN  j  X   8rO  rP  hcj!  rQ  j  X   3rR  rS  hcj!  rT  j  jg  rU  hcj!  rV  j  jB  rW  hcj!  rX  j  j4  rY  hcj!  rZ  j  jg  r[  hcj!  r\  j  jg  r]  hcj  r^  hcj!  r_  j  X   
    r`  ra  hcj  rb  j  j
  rc  hcj!  rd  j  jg  re  hcj!  rf  j  jg  rg  hcj!  rh  j  jg  ri  hcj!  rj  j  jg  rk  hcj!  rl  j  jg  rm  hcj!  rn  j  jg  ro  hcj!  rp  j  jg  rq  hcj!  rr  j  j  rs  hcj  rt  hcj!  ru  j  X   
    rv  rw  hcj  rx  j  jO  ry  hcj!  rz  j  jg  r{  hcj!  r|  j  jg  r}  hcj!  r~  j  j=  r  hcj!  r  j  jg  r  hcj!  r  j  X   7r  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j4  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j4  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  X   9r  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j=  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jB  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j
  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  j4  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  j=  r  hcj!  r  j  jg  r  hcj!  r  j  jB  r  hcj!  r  j  jg  r  hcj!  r  j  jO  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj  r  hcj  r  j  X   

r  r  jg  X   test2r  r  j  j  r   jz  X   ::r  r  j  j  r  h5X   Sudokur  r  j  j  r  h5X   Intr  r  j  j  r	  jg  X   test2r
  r  j  j  r  jz  j  r
  j  j  r  j
  X
   makeSudokur  r  j  j  r  hcj  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r   hcj!  r!  j  jO  r"  hcj!  r#  j  jg  r$  hcj!  r%  j  jg  r&  hcj  r'  hcj!  r(  j  X   
    r)  r*  hcj  r+  j  jg  r,  hcj!  r-  j  jg  r.  hcj!  r/  j  jg  r0  hcj!  r1  j  j
  r2  hcj!  r3  j  jg  r4  hcj!  r5  j  j=  r6  hcj!  r7  j  jg  r8  hcj!  r9  j  jg  r:  hcj!  r;  j  jg  r<  hcj  r=  hcj!  r>  j  X   
    r?  r@  hcj  rA  j  jg  rB  hcj!  rC  j  jg  rD  hcj!  rE  j  j4  rF  hcj!  rG  j  jg  rH  hcj!  rI  j  jg  rJ  hcj!  rK  j  jg  rL  hcj!  rM  j  jg  rN  hcj!  rO  j  jR  rP  hcj!  rQ  j  jg  rR  hcj  rS  hcj!  rT  j  X   
    rU  rV  hcj  rW  j  jg  rX  hcj!  rY  j  jg  rZ  hcj!  r[  j  jg  r\  hcj!  r]  j  jB  r^  hcj!  r_  j  jg  r`  hcj!  ra  j  jg  rb  hcj!  rc  j  jg  rd  e(hcj!  re  j  jg  rf  hcj!  rg  j  j4  rh  hcj  ri  hcj!  rj  j  X   
    rk  rl  hcj  rm  j  j  rn  hcj!  ro  j  jg  rp  hcj!  rq  j  jO  rr  hcj!  rs  j  jg  rt  hcj!  ru  j  jg  rv  hcj!  rw  j  j
  rx  hcj!  ry  j  jg  rz  hcj!  r{  j  j=  r|  hcj!  r}  j  jg  r~  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jB  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  jO  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j4  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  j4  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  j=  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj  r  j  X   

r  r  jg  X	   testSmallr  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Sudokur  r  j  j  r  h5X   Intr  r  j  j  r  jg  X	   testSmallr  r  j  j  r  jz  j  r  j  j  r  j
  X
   makeSudokur  r  j  j  r  hcj  r  j  X   
    r  r  hcj  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r   j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r	  hcj!  r
  j  jg  r  hcj!  r  j  j
  r
  hcj!  r  j  j  r  hcj!  r  j  j=  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r   j  jg  r!  hcj!  r"  j  jg  r#  hcj!  r$  j  jB  r%  hcj!  r&  j  jg  r'  hcj!  r(  j  jg  r)  hcj!  r*  j  jg  r+  hcj!  r,  j  jg  r-  hcj!  r.  j  j=  r/  hcj  r0  hcj!  r1  j  X   
    r2  r3  hcj  r4  j  jg  r5  hcj!  r6  j  jR  r7  hcj!  r8  j  jg  r9  hcj!  r:  j  jg  r;  hcj!  r<  j  jg  r=  hcj!  r>  j  jg  r?  hcj!  r@  j  jg  rA  hcj!  rB  j  jg  rC  hcj!  rD  j  jg  rE  hcj  rF  hcj!  rG  j  X   
    rH  rI  hcj  rJ  j  j  rK  hcj!  rL  j  jB  rM  hcj!  rN  j  jg  rO  hcj!  rP  j  jg  rQ  hcj!  rR  j  jg  rS  hcj!  rT  j  jg  rU  hcj!  rV  j  jg  rW  hcj!  rX  j  jg  rY  hcj!  rZ  j  jg  r[  hcj  r\  hcj!  r]  j  X   
    r^  r_  hcj  r`  j  jg  ra  hcj!  rb  j  jg  rc  hcj!  rd  j  jg  re  hcj!  rf  j  jg  rg  hcj!  rh  j  jg  ri  hcj!  rj  j  j  rk  hcj!  rl  j  j4  rm  hcj!  rn  j  jg  ro  hcj!  rp  j  jg  rq  hcj  rr  hcj!  rs  j  X   
    rt  ru  hcj  rv  j  jg  rw  hcj!  rx  j  j=  ry  hcj!  rz  j  jg  r{  hcj!  r|  j  jg  r}  hcj!  r~  j  jg  r  hcj!  r  j  j4  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  j  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r  j  jg  r  hcj  r  hcj  r  j  X   

r  r  jg  X   testHardr  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Sudokur  r  j  j  r  h5X   Intr  r  j  j  r  jg  X   testHardr  r  j  j  r  jz  j  r  j  j  r  j
  X
   makeSudokur  r  j  j  r  hcj  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jO  r  hcj!  r  j  jg  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jB  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j4  r   hcj!  r  j  jg  r  hcj!  r  j  jB  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r	  j  jg  r
  hcj!  r  j  jg  r  hcj  r
  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jO  r  hcj!  r  j  jg  r   hcj!  r!  j  jg  r"  hcj  r#  hcj!  r$  j  X   
    r%  r&  hcj  r'  j  j  r(  hcj!  r)  j  jg  r*  hcj!  r+  j  jg  r,  hcj!  r-  j  jg  r.  hcj!  r/  j  jg  r0  hcj!  r1  j  jg  r2  hcj!  r3  j  jg  r4  hcj!  r5  j  jg  r6  hcj!  r7  j  j
  r8  hcj  r9  hcj!  r:  j  X   
    r;  r<  hcj  r=  j  jg  r>  hcj!  r?  j  jg  r@  hcj!  rA  j  jg  rB  hcj!  rC  j  j  rD  hcj!  rE  j  jg  rF  hcj!  rG  j  j  rH  hcj!  rI  j  jg  rJ  hcj!  rK  j  jg  rL  hcj!  rM  j  jg  rN  hcj  rO  hcj!  rP  j  X   
    rQ  rR  hcj  rS  j  jg  rT  hcj!  rU  j  j4  rV  hcj!  rW  j  j  rX  hcj!  rY  j  jg  rZ  hcj!  r[  j  jR  r\  hcj!  r]  j  jg  r^  hcj!  r_  j  j  r`  hcj!  ra  j  jO  rb  hcj!  rc  j  jg  rd  hcj  re  hcj!  rf  j  X   
    rg  rh  hcj  ri  j  jg  rj  hcj!  rk  j  jB  rl  hcj!  rm  j  jg  rn  hcj!  ro  j  jg  rp  hcj!  rq  j  jg  rr  hcj!  rs  j  jg  rt  hcj!  ru  j  jg  rv  hcj!  rw  j  j=  rx  hcj!  ry  j  jg  rz  hcj  r{  hcj!  r|  j  X   
    r}  r~  hcj  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  j=  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jB  r  hcj!  r  j  jg  r  hcj  r  hcj  r  j  X   

r  r  jg  X	   testHard2r  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Sudokur  r  j  j  r  h5X   Intr  r  j  j  r  jg  X	   testHard2r  r  j  j  r  jz  j  r  j  j  r  j
  X
   makeSudokur  r  j  j  r  hcj  r  j  X   
    r  r  hcj  r  j  jR  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jB  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  j=  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jO  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r   hcj!  r  j  X   
    r  r  hcj  r  j  jB  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r	  hcj!  r
  j  jg  r  hcj!  r  j  j  r
  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j4  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r   j  jg  r!  hcj!  r"  j  jg  r#  hcj!  r$  j  jg  r%  hcj!  r&  j  j
  r'  hcj!  r(  j  jg  r)  hcj!  r*  j  jg  r+  hcj  r,  hcj!  r-  j  X   
    r.  r/  hcj  r0  j  jg  r1  hcj!  r2  j  jg  r3  hcj!  r4  j  jg  r5  hcj!  r6  j  jR  r7  hcj!  r8  j  jg  r9  hcj!  r:  j  j  r;  hcj!  r<  j  jg  r=  hcj!  r>  j  j=  r?  hcj!  r@  j  jg  rA  hcj  rB  hcj!  rC  j  X   
    rD  rE  hcj  rF  j  jO  rG  hcj!  rH  j  jg  rI  hcj!  rJ  j  jg  rK  hcj!  rL  j  jg  rM  hcj!  rN  j  jg  rO  hcj!  rP  j  jg  rQ  hcj!  rR  j  jg  rS  hcj!  rT  j  jg  rU  hcj!  rV  j  jg  rW  hcj  rX  hcj!  rY  j  X   
    rZ  r[  hcj  r\  j  jg  r]  hcj!  r^  j  jg  r_  hcj!  r`  j  j4  ra  hcj!  rb  j  jg  rc  hcj!  rd  j  jg  re  hcj!  rf  j  jB  rg  hcj!  rh  j  jg  ri  hcj!  rj  j  jg  rk  hcj!  rl  j  j  rm  hcj  rn  hcj  ro  j  X   

rp  rq  jg  X   testHWrr  rs  j  j  rt  jz  X   ::ru  rv  j  j  rw  h5X   Sudokurx  ry  j  j  rz  h5X   Intr{  r|  j  j  r}  jg  X   testHWr~  r  j  j  r  jz  j  r  j  j  r  j
  X
   makeSudokur  r  j  j  r  hcj  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  j
  r  hcj  r  hcj!  r  j  X	       
    r  r  hcj  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jB  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jB  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  jg  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj  r  hcj!  r  j  X   
    r  r  hcj  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jR  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r   hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jO  r  hcj  r	  hcj!  r
  j  X   
    r  r  hcj  r
  j  jO  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j
  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj!  r  j  j  r  hcj!  r  j  jg  r  hcj!  r  j  jg  r  hcj  r  hcj!  r   j  X   
    r!  r"  hcj  r#  j  jg  r$  hcj!  r%  j  jg  r&  hcj!  r'  j  jg  r(  hcj!  r)  j  jg  r*  hcj!  r+  j  jO  r,  hcj!  r-  j  jB  r.  hcj!  r/  j  jg  r0  hcj!  r1  j  j4  r2  hcj!  r3  j  jg  r4  hcj  r5  hcj!  r6  j  X   
    r7  r8  hcj  r9  j  j4  r:  hcj!  r;  j  jg  r<  hcj!  r=  j  jB  r>  hcj!  r?  j  jg  r@  hcj!  rA  j  jg  rB  hcj!  rC  j  j  rD  hcj!  rE  j  jg  rF  hcj!  rG  j  jg  rH  hcj!  rI  j  jg  rJ  hcj  rK  hcj  rL  j  X   

rM  rN  jg  X	   testToughrO  rP  j  j  rQ  jz  X   ::rR  rS  j  j  rT  h5X   SudokurU  rV  j  j  rW  h5X   IntrX  rY  j  j  rZ  jg  X	   testToughr[  r\  j  j  r]  jz  j  r^  j  j  r_  j
  X
   makeSudokur`  ra  j  j  rb  jn  j  rc  j  j  rd  j
  X   mapre  rf  j  j  rg  hcj  rh  j
  X   mapri  rj  j  j  rk  j
  X   readrl  rm  j  j  rn  jn  jk  ro  j  j  rp  j
  X   wordsrq  rr  hcj>  rs  j  j  rt  jn  j  ru  j  j  rv  j
  X   linesrw  rx  j  j  ry  jn  j  rz  j  X   
 r{  r|  j  jm
  r}  j  X   8 3 0  0 0 0  0 4 6r~  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
 r  r  j  jm
  r  j  X   0 2 0  1 0 4  0 3 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
 r  r  j  jm
  r  j  X   0 0 0  0 0 0  0 0 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
 r  r  j  jm
  r  j  X   0 0 2  9 0 6  5 0 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
 r  r  j  jm
  r  j  X   1 4 0  0 0 0  0 2 3r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  e(j  X   
 r  r  j  jm
  r  j  X   0 0 5  4 0 3  1 0 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
 r  r  j  jm
  r  j  X   0 0 0  0 0 0  0 0 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
 r  r  j  jm
  r  j  X   0 6 0  3 0 8  0 7 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
 r  r  j  jm
  r  j  X   9 5 0  0 0 0  0 6 2r  r  j-  j  r  j-  j
  r  j  jm
  r  j  X   

r  r  jg  X   testDiabolicalr  r  j  j  r  jz  X   ::r  r  j  j  r  h5X   Sudokur  r  j  j  r  h5X   Intr  r  j  X    
r  r  jg  X   testDiabolicalr  r  j  j  r  jz  j  r  j  j  r  j
  X
   makeSudokur  r  j  j  r  jn  j  r  j  j  r  j
  X   mapr  r  j  j  r  hcj  r  j
  X   mapr  r  j  j  r  j
  X   readr  r  j  j  r  jn  jk  r  j  j  r  j
  X   wordsr  r  hcj>  r  j  j  r  jn  j  r  j  j  r  j
  X   linesr  r  j  j  r   jn  j  r  j  X   
  r  r  j  jm
  r  j  X   8 0 0  7 0 1  0 0 2r  r  j-  j  r  j-  j
  r  j  jm
  r	  jn  X   ++r
  r  j  X   
  r  r
  j  jm
  r  j  X   0 0 6  0 0 0  7 0 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
  r  r  j  jm
  r  j  X   0 1 7  0 0 0  8 9 0r  r  j-  j  r  j-  j
  r  j  jm
  r  jn  X   ++r  r  j  X   
  r   r!  j  jm
  r"  j  X   0 0 0  1 7 3  0 0 0r#  r$  j-  j  r%  j-  j
  r&  j  jm
  r'  jn  X   ++r(  r)  j  X   
  r*  r+  j  jm
  r,  j  X   7 0 0  0 0 0  0 0 6r-  r.  j-  j  r/  j-  j
  r0  j  jm
  r1  jn  X   ++r2  r3  j  X   
  r4  r5  j  jm
  r6  j  X   0 0 0  9 5 6  0 0 0r7  r8  j-  j  r9  j-  j
  r:  j  jm
  r;  jn  X   ++r<  r=  j  X   
  r>  r?  j  jm
  r@  j  X   0 9 5  0 0 0  4 1 0rA  rB  j-  j  rC  j-  j
  rD  j  jm
  rE  jn  X   ++rF  rG  j  X   
  rH  rI  j  jm
  rJ  j  X   0 0 8  0 0 0  5 0 0rK  rL  j-  j  rM  j-  j
  rN  j  jm
  rO  jn  X   ++rP  rQ  j  X   
  rR  rS  j  jm
  rT  j  X   3 0 0  6 0 5  0 0 7rU  rV  j-  j  rW  j-  j
  rX  j  jm
  rY  j  X   

rZ  r[  jg  X   mainr\  r]  j  j  r^  jz  X   ::r_  r`  j  j  ra  h5X   IOrb  rc  j  j  rd  j  X   ()re  rf  j  j  rg  jg  X   mainrh  ri  j  j  rj  jz  j  rk  j  j  rl  hX   dorm  rn  j  X   
    ro  rp  hX   letrq  rr  j  X	   
        rs  rt  j
  X   solve'ru  rv  j  j  rw  j
  j[  rx  j  j  ry  jz  j  rz  j  j  r{  hX   caser|  r}  j  j  r~  j
  X   solver  r  j  j  r  j
  j[  r  j  j  r  hX   ofr  r  j  X
   
            r  r  h5X   []r  r  j  j  r  jz  X   ->r  r  j  j  r  j
  X   failr  r  j  j  r  jn  j  r  j  j  r  j  jm
  r  j  X   couldn't solve: r  r  j  jm
  r  j  j  r  jn  X   ++r  r  j  j  r  j
  X   showr  r  j  j  r  j
  j[  r  j  X
   
            r  r  j
  X   solsr  r  j  j  r  jz  X   ->r  r  j  j  r  j
  X   returnr  r  j  j  r  j
  X   solsr  r  j  X   
    r  r  j
  X   mapM_r  r  j  j  r  hcj  r  jg  j  r  j
  j[  r  j  j  r  jz  X   ->r  r  j  j  r  j
  X   solve'r  r  j  j  r  j
  j[  r  j  j  r  jn  X   >>=r  r  j  j  r  j
  X   putStrLnr  r  jn  jk  r  j
  X   showr  r  hcj>  r  j  j  r  hcj  r  j
  X   testr  r  hcj!  r  j
  X   test2r  r  hcj!  r  j
  X	   testSmallr  r  hcj!  r  j
  X   testHardr  r  hcj!  r  j
  X	   testHard2r  r  hcj!  r  j
  X   testHWr  r  hcj!  r  j
  X	   testToughr  r  hcj!  r  j
  X   testDiabolicalr  r  hcj  r  j  X   
    r  r  j
  X   returnr  r  j  j  r  j  X   ()r  r  j  X   

r  r  hX   \endr  r  j  j  r  j  X   coder  r  j  j  r  j  j  r  j  j  r  j  X   

r  r  hX   \endr  r  j  j  r  j  X   documentr  r  j  j  r  j  j  r  j  j  r  e.